<?php
if(!class_exists('hotelian_Theme_Functions')){
    class hotelian_Theme_Functions{
        public function __construct(){
            $this -> hook();
        }
        public static function locate_my_template($template_names, $load = false, $require_once = true, $args = array()){
            $located    = '';
            foreach ( (array) $template_names as &$template_name ) {
                if ( ! $template_name ) {
                    continue;
                }
                if(!preg_match('/\.php$/i', $template_name)){
                    $template_name  .= '.php';
                }
                if ( file_exists( get_template_directory() . '/templaza-framework/templates/' . $template_name ) ) {
                    $located = get_template_directory() . '/templaza-framework/templates/' . $template_name;
                    break;
                }
            }
            if($load && $located != '') {
                load_template($located, $require_once, $args);
            }

            return $located;
        }
        public function load_my_layout($partial, $load = true, $require_once = true, $args = array()){
            $partial    = str_replace('.', '/', $partial);
            $located    = self::locate_my_template((array) $partial, $load, $require_once, $args);
            return $located;
        }
        public function hook(){

            add_filter('wp_kses_allowed_html', array($this, 'hotelian_wpkses_post_tags'), 10, 2);

            add_filter('edit_post_link', array($this, 'hotelian_edit_post_link'),10,3);
            add_filter('the_content_more_link', array($this, 'hotelian_modify_read_more_link'));

            add_action('hotelian_get_postviews',array($this,'hotelian_get_post_views'));
            add_action('hotelian_set_postviews',array($this,'hotelian_set_post_views'));
            add_action('hotelian_get_commentcount_post',array($this,'hotelian_get_comment_count_post'));
            add_action('hotelian_breadcrumb',array($this,'hotelian_breadcrumbs'));
            add_action('hotelian_share_post',array($this,'hotelian_get_share_social'));
            add_action('hotelian_pagination',array($this,'hotelian_pagination'));
            add_action('hotelian_gallery_post',array($this,'hotelian_get_gallery_post'));
            add_action('hotelian_image_post',array($this,'hotelian_get_image_post'));
            add_action('hotelian_video_post',array($this,'hotelian_get_video_post'));
            add_action('hotelian_audio_post',array($this,'hotelian_get_audio_post'));
            add_action('hotelian_title_post',array($this,'hotelian_get_title_post'));
            add_action('hotelian_meta_post_header',array($this,'hotelian_get_meta_post_header'));
            add_action('hotelian_meta_post_footer',array($this,'hotelian_get_meta_post_footer'));
            add_action('hotelian_link_post',array($this,'hotelian_get_link_post'));
            add_action('hotelian_quote_post',array($this,'hotelian_get_quote_post'));
            add_action('hotelian_excerpt_post',array($this,'hotelian_get_excerpt_post'));
            add_action('hotelian_readmore_post',array($this,'hotelian_get_readmore_post'));
            add_action('hotelian_single_title_post',array($this,'hotelian_single_get_title_post'));
            add_action('hotelian_single_meta_post',array($this,'hotelian_single_get_meta_post'));
            add_action('hotelian_single_tag_post',array($this,'hotelian_single_get_tag_post'));
            add_action('hotelian_single_next_post',array($this,'hotelian_single_get_next_post'));
            add_action('hotelian_single_author_post',array($this,'hotelian_single_get_author_post'));
            add_action('hotelian_single_related_post',array($this,'hotelian_single_get_related_post'));
            add_action('hotelian_author_social',array($this,'hotelian_author_social'));
            add_action('hotelian_search_no_result',array($this,'hotelian_search_no_result'));
            add_action('hotelian_archive_no_result',array($this,'hotelian_archive_no_result'));
            add_action('hotelian_all_taxonomy',array($this,'hotelian_all_taxonomy'),10,2);
            add_action('hotelian_post_taxonomy',array($this,'hotelian_post_taxonomy'),10,1);
            add_filter('hotelian_cause_donate',array($this,'hotelian_cause_donate'),10,1);
            add_action('hotelian_cause_donate_archive',array($this,'hotelian_cause_donate_archive'),10,1);

        }

        public function hotelian_modify_read_more_link() {
            return '';
        }

        public function hotelian_get_post_views($postID)
        {
            $args   = get_defined_vars();
            $this->load_my_layout('template-parts.content-views',true,false,$args);
        }

        function hotelian_set_post_views($postID)
        {
            $count_key = 'post_views_count';
            $count = get_post_meta($postID, $count_key, true);
            if ($count == '') {
                $count = 0;
                delete_post_meta($postID, $count_key);
                add_post_meta($postID, $count_key, '0');
            } else {
                $count++; // Incremental view
                update_post_meta($postID, $count_key, $count); // update count
            }
        }

        public function hotelian_get_comment_count_post()
        {
            $hotelian_comment_count = wp_count_comments(get_the_ID());
            if ($hotelian_comment_count->approved == 1) {
                echo esc_html__('Comment:','hotelian').' '.esc_html($hotelian_comment_count->approved);
            }else{
                echo esc_html__('Comments:','hotelian').' '.esc_html($hotelian_comment_count->approved);
            }
        }

        public function hotelian_wpkses_post_tags( $tags, $context ) {
            if ( 'post' === $context ) {
                $tags['iframe'] = array(
                    'src'             => true,
                    'height'          => true,
                    'width'           => true,
                    'frameborder'     => true,
                    'allowfullscreen' => true,
                    'data-uk-responsive' => true,
                    'data-uk-video' => true,
                );
                $tags['form'] = array(
                    'action'         => true,
                    'class'          => true,
                    'id'             => true,
                    'accept'         => true,
                    'accept-charset' => true,
                    'enctype'        => true,
                    'method'         => true,
                    'name'           => true,
                    'data-formid'         => true,
                    'target'         => true,
                    'novalidate'         => true,
                    'data-token'         => true,
                );
                $tags['input'] = array(
                    'class' => true,
                    'id'    => true,
                    'name'  => true,
                    'value' => true,
                    'type'  => true,
                    'placeholder'  => true,
                    'step'  => true,
                    'min'  => true,
                    'max'  => true,
                    'title'  => true,
                    'size'  => true,
                    'inputmode'  => true,
                    'autocomplete'  => true,
                );
            }

            return $tags;
        }

        function hotelian_author_social () {
            $author_social = array(
                    'phone' => esc_html__('Phone','hotelian'),
                    'facebook' => esc_html__('Join with US','hotelian'),
                    'twitter' => esc_html__('Follow US','hotelian'),
                    'instagram' => esc_html__('Our Instagram','hotelian'),
                    'dribbble' => esc_html__('Our Dribbble','hotelian'),
                    'linkedin' => esc_html__('Our Linkedin','hotelian'),
                    'pinterest' => esc_html__('Our Pinterest','hotelian'),
                    'youtube' => esc_html__('Our Youtube','hotelian'),
                    'vimeo' => esc_html__('Our Vimeo','hotelian'),
                    'flickr' => esc_html__('Our Flickr','hotelian'),
                    'tumblr' => esc_html__('Our Tumblr','hotelian'),
                    'whatsapp' => esc_html__('Our whatsapp','hotelian')
            );
            foreach($author_social as $key=>$item){
                if(get_the_author_meta($key)){
                    if($key =='phone'){
                        ?>
                        <a class="uk-margin-right" href="tel:<?php echo esc_url(get_the_author_meta($key));?>" target="_blank">
                            <i class="fas fa-<?php echo esc_attr($key);?>"></i> <span><?php echo esc_html($item);?></span>
                        </a>
                        <?php
                    }else{
                    ?>
                        <a class="uk-margin-right" href="<?php echo esc_url(get_the_author_meta($key));?>" target="_blank">
                            <i class="fab fa-<?php echo esc_attr($key);?>"></i> <span><?php echo esc_html($item);?></span>
                        </a>
                    <?php
                    }
                }
            }
        }

        public function hotelian_pagination() {
            the_posts_pagination( array(
                'type' => 'plain',
                'mid_size' => 2,
                'prev_text' => ent2ncr('<i class="fa fa-angle-double-left"></i>'),
                'next_text' => ent2ncr('<i class="fa fa-angle-double-right"></i>'),
                'screen_reader_text' => '',
            ) );
        }
        public function hotelian_edit_post_link($link, $post_id, $text) {
            if ( is_admin() ) {
                return $link;
            }

            $edit_url = get_edit_post_link( $post_id );

            if ( ! $edit_url ) {
                return;
            }

            return '<span class="post-edit"><a href="' . esc_url( $edit_url ) . '">' . esc_html__('Edit','hotelian') . '</a></span>';
        }

        public function hotelian_get_share_social () {
            $this->load_my_layout('template-parts.content-share',true,false);
        }

        public function hotelian_breadcrumbs() {
            $this->load_my_layout('template-parts.breadcrumb_html',true,false);
        }

        public function hotelian_get_gallery_post() {
            $this->load_my_layout('template-parts.content-gallery',true,false);
        }

        public function hotelian_get_image_post() {
            $this->load_my_layout('template-parts.content-image',true,false);
        }

        public function hotelian_get_video_post() {
            $this->load_my_layout('template-parts.content-video',true,false);
        }

        public function hotelian_get_audio_post() {
            $this->load_my_layout('template-parts.content-audio',true,false);
        }

        public function hotelian_get_title_post() {

            $this->load_my_layout('template-parts.content-title',true,false);
        }

        public function hotelian_get_meta_post_header() {
            $this->load_my_layout('template-parts.content-meta-header',true,false);
        }
	    public function hotelian_get_meta_post_footer() {
		    $this->load_my_layout('template-parts.content-meta-footer',true,false);
	    }

        public function hotelian_get_link_post() {
            $this->load_my_layout('template-parts.content-link',true,false);
        }

        public function hotelian_get_quote_post() {
            $this->load_my_layout('template-parts.content-quote',true,false);
        }

        public function hotelian_get_excerpt_post() {
            $this->load_my_layout('template-parts.content-excerpt',true,false);
        }

        public function hotelian_get_readmore_post() {
            $this->load_my_layout('template-parts.content-readmore',true,false);
        }

        public function hotelian_single_get_title_post() {
            $this->load_my_layout('template-parts.content-single-title',true,false);
        }

        public function hotelian_single_get_meta_post() {
            $this->load_my_layout('template-parts.content-single-meta',true,false);
        }

        public function hotelian_single_get_tag_post() {
            $this->load_my_layout('template-parts.content-single-tag',true,false);
        }

        public function hotelian_single_get_next_post() {
            $this->load_my_layout('template-parts.content-single-next-preview',true,false);
        }

        public function hotelian_single_get_author_post() {
            $this->load_my_layout('template-parts.content-single-author',true,false);
        }

        public function hotelian_single_get_related_post() {
            $this->load_my_layout('template-parts.content-single-related',true,false);
        }

        public  function hotelian_search_no_result( ) {
            $this->load_my_layout('template-parts.content-search-no-result', true, false);
        }

        public  function hotelian_archive_no_result( ) {
            $this->load_my_layout('template-parts.content-archive-no-result', true, false);
        }

        public  function hotelian_all_taxonomy( $taxonomy,$empty) {
            $args   = get_defined_vars();
            $this->load_my_layout('template-parts.all-taxonomy', true, false,$args);
        }

        public  function hotelian_post_taxonomy( $taxonomy) {
            $args   = get_defined_vars();
            $this->load_my_layout('template-parts.post-taxonomy', true, false,$args);
        }

        public  function hotelian_cause_donate($postID) {
            $args   = get_defined_vars();
            ob_start();
            $this->load_my_layout('template-parts.cause-donate', true, false,$args);
            $donate_count = ob_get_contents();
            ob_end_clean();
            return $donate_count;
        }

        public  function hotelian_cause_donate_archive($postID) {
            $args   = get_defined_vars();
            $this->load_my_layout('template-parts.cause-donate', true, false,$args);
        }

    }

    $hotelian_theme_functions = new hotelian_Theme_Functions();

}